<?php
require("../includes/header.php");

require_once("../config/connection.php");

$query = "SELECT appname FROM app_settings";
$result = $mysqli->query($query);
$row = $result->fetch_assoc();
$appname = $row['appname'];

// Sanitize and validate ID parameter
$id = get_int('id');

if ($id > 0) {
    // Fetch the menu item data from the database
    $query = "SELECT * FROM app_menu WHERE id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $order_id = $row['order_id'];
        $menu_name = $row['menu_name'];
        $menu_icon = $row['menu_icon'];
        $menu_type = $row['menu_type'];
        $menu_data = $row['menu_data'];
        $isEnabled = $row['is_enabled'];
        $toolbar_color = $row['toolbar_color'];
    } else {
        die("Menu item not found.");
    }
    $stmt->close();
} else {
    die("Invalid menu ID.");
}
?>
<title>Edit Menu</title>

<meta name="description" content="" />

</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php require("../includes/sidebar.php") ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php require("../includes/navbar.php") ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container-xxl flex-grow-1 container-p-y">
                        <div class="row">
                            <div class="form-container">
                                <button class="btn btn-primary" style="float:right;" onclick="goBack()">Go Back</button>
                                <h4>Edit Menu</h4>

                                <form method="POST" action="../functions/update_menu_item.php">
                                    <?= csrf_input(); ?>
                                    <div class="form-group">
                                        <label for="menuIcon">Menu ID</label>
                                        <div class="input-group">
                                            <input type="text" id="id" class="form-control" name="id" readonly value="<?php echo $id; ?>" />
                                        </div>
                                    </div>
                                    <br/>

                                    <div class="form-group">
                                        <label for="menuName">Menu Name</label>
                                        <input type="text" id="menu_name" class="form-control" name="menu_name" value="<?php echo $menu_name; ?>" />
                                    </div>
                                    <br/>

                                    <div class="form-group">
                                        <label for="menuIcon">Menu Icon</label>
                                        <textarea rows="4" cols="50" class="form-control" id="menu_icon" name="menu_icon"><?php echo $menu_icon; ?></textarea>
                                    </div>
                                    <br/>

                                  <div class="form-group">
    <label for="menuType">Menu Type</label>
    <select class="form-control" id="menu_type" name="menu_type" required>
        <option value="webview" <?php echo $menu_type === 'webview' ? 'selected' : ''; ?>>Webview</option>
        <option value="wordpress" <?php echo $menu_type === 'wordpress' ? 'selected' : ''; ?>>WordPress</option>
        <option value="intent" <?php echo $menu_type === 'intent' ? 'selected' : ''; ?>>Intent</option>
        <option value="custom" <?php echo $menu_type === 'custom' ? 'selected' : ''; ?>>Custom</option>
         <option value="rss" <?php echo $menu_type === 'rss' ? 'selected' : ''; ?>>RSS Feed</option>
        <option value="rss" <?php echo $menu_type === 'ytrss' ? 'selected' : ''; ?>>Youtube RSS</option>
        <option value="" <?php echo empty($menu_type) ? 'selected' : ''; ?>>Select an option</option>
    </select>
</div>

                                    <br/>

                                    <div class="form-group">
                                        <label for="menuData">Menu Data</label>
                                        <input type="text" class="form-control" id="menu_data" name="menu_data" value="<?php echo $menu_data; ?>" />
                                    </div>
                                    <br/>

                                    <!-- New Toolbar Color Input -->
                                    <div class="form-group" id="toolbar-color-group">
                                        <label for="toolbarColor">Toolbar Color</label>
                                       <input type="text" id="toolbar_color" name="toolbar_color" 
                                            
    style="color: #697a8d;
    background-color: #fff;
    background-clip: padding-box;
    border: 1px solid #d9dee3;
    appearance: none;
    border-radius: 0.375rem;
    transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;
    display: block;
    width: 100%;
    padding: 0.4375rem 0.875rem;
    font-size: .9375rem;
    font-weight: 400;
    line-height: 1.53;"
    value="<?php echo $toolbar_color ?>" data-coloris>
                                    </div>
                                    <br/>

                                    <div class="form-group">
                                        <button type="submit" style="float:right;" class="btn btn-primary">Save Changes</button>
                                        <div class="form-check">
                                            <input class="form-check-input" name="is_enabled" type="checkbox" value="" id="is_enabled" <?php echo $isEnabled == 1 ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="defaultCheck3">Enabled</label>
                                        </div>
                                    </div>
                                    <br/>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- / Content -->
                 <script type="text/javascript">
        Coloris({
            alpha: false,
            margin: 5,
            format: 'hex',
            theme: 'default',
            focusInput: true,
            el: '.coloris',
            swatches:       [
                '#cceaff',
                '#ffcccc',
                '#feffcc',
                '#ffccf1',
                '#d1ffcc',
                '#cceaff',
                '#cdccff',
                '#daccff',
                '#efccff',
                '#fff1cc',
                '#b1adff',
                            ] });
    </script>
<link rel="stylesheet" href="../assets/coloris.min.css"/>
<script src="../assets/coloris.min.js"></script>


<script>
    document.addEventListener("DOMContentLoaded", function () {
        const menuTypeSelect = document.getElementById("menu_type");
        const toolbarColorGroup = document.getElementById("toolbar-color-group");
        const form = document.querySelector("form");
        const menuDataInput = document.getElementById("menu_data");

        // Function to toggle Toolbar Color visibility
        function toggleToolbarColor() {
            if (menuTypeSelect.value === "webview") {
                toolbarColorGroup.style.display = "block"; // Show
            } else {
                toolbarColorGroup.style.display = "none"; // Hide
            }
        }

        // Function to validate WordPress URL
        function validateWordPressURL(event) {
            if (menuTypeSelect.value === "wordpress") {
                const menuData = menuDataInput.value.trim();
                if (!menuData.endsWith("/")) {
                    event.preventDefault(); // Prevent form submission
                    alert("For WordPress menu type, the URL must end with a '/'.");
                }
            }
        }

        // Run the toggle function on page load (for default value)
        toggleToolbarColor();

        // Add event listener for changes to the Menu Type dropdown
        menuTypeSelect.addEventListener("change", toggleToolbarColor);

        // Add form submit event listener to validate WordPress URL
        form.addEventListener("submit", validateWordPressURL);
    });
</script>

            </body>

<?php require("../includes/footer.php"); ?>
</html>
